@extends('partials.main')
@section('title')
    {{ 'Hotel Reservations' }}
@endsection
@section('content')
    <style>
        .fa-star {
            color: #ff7550;
        }

        .tg-description span {
            color: #ff7550;
        }

        .tg-populartourvtwo .tg-populartourcontent .tg-description p {
            margin: 0 0 30px;
            overflow: hidden;
            display: -webkit-box;
            -webkit-line-clamp: 5;
            -webkit-box-orient: vertical;
        }

        .tg-populartourfoot {
            width: 100%;
            float: left;
            padding: 55px 0 0;
            border-top: 1px solid #e6e6e6;
        }

        .hotel-img {
            width: 410px !important;
            height: 273px !important;
            object-fit: cover;
        }

        /* card-dwon */
        .card {

            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        img.card-img-top {
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        }

        .blog-cardbody {
            padding: 10px;
        }

        .card.card-dwon {
            margin-bottom: 20px;
        }

        .list-blog {
            margin-bottom: 20px;
        }


        .card-block {
    padding-bottom: 0px;
    padding-right: 15px;
    padding-left: 15px;
}

        img.img-fluid.imt {
            height: 142px;
            object-fit: cover;
            border-bottom-left-radius: 5px;
            border-top-left-radius: 5px;
            width: 100%;
        }
        p.card-text{
    margin: 0 0 0px !important;
}
    </style>



    <!--************************************
                        Inner Banner Start
                      *************************************-->
    <section class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
        data-image-src="../images/Home/sunrise-4823732_1280.jpg">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <h1>Blog</h1>
                        <h2>Lorem ipsum dolor sit amet consectetur adipisicing elit. Ducimus tempora exercitationem
                            deserunt.</h2>
                        <ol class="tg-breadcrumb">
                            <li><a href="javascript:void(0);">Home</a></li>
                            <li class="tg-active">Hotel Reservations</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--************************************
                        Inner Banner End
                      *************************************-->
    <!--************************************
                        Main Start
                      *************************************-->
    <main id="tg-main" class="tg-main tg-sectionspace tg-haslayout tg-bglight">
        <div class="container">
            <div class="row">
                
                <div id="tg-twocolumns" class="tg-twocolumns">
                    
                    <div class="col-xs-12 col-sm-8 col-md-8 col-lg-8 pull-left">
                        <div class="tg-widgettitle">
                            <h3>Latest Tour</h3>
                        </div>
                        <div class="card-list">
                        @foreach ($posts as $post)
                        <div class="col-xs-12 col-sm-4 col-md-4 col-lg-4">
                            <div class="card card-dwon">

                                <div class="top-image">
                                    <img class="card-img-top" src="{{ asset('thumbnails/' . $post->thumbnail) }}" 
                                        alt="Card image cap">
                                </div>


                                <div class="card-body blog-cardbody">
                                    <p> <b>{{$post->title}}</b></p>
                                    <p class="card-text">{{$post->shdescription}}</p>

                                </div>
                            </div>
                        </div> 
                        @endforeach
                         

                         


                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-4 col-md-4 col-lg-4 pull-right">
                        <aside id="tg-sidebar" class="tg-sidebar">
                            <div class="tg-widget tg-widgetlatesttour">
                                <div class="tg-widgettitle">
                                    <h3>Latest Tour</h3>
                                </div>
                                <div class="tg-widgetcontent">
                                    <div class="row">

                                        <div class="col-md-12 ">
                                            <div class="card list-blog">
                                                <div class="row ">
                                                    <div class="col-md-4 ">
                                                        <div class="list-img">
                                                            <img class="img-fluid imt"
                                                                src="images/Home/pexels-kevin-burnell-16515838.jpg">
                                                        </div>

                                                    </div>
                                                    <div class="col-md-8">
                                                        <div class="card-block">
                                                            <p> <b>Lorem ipsum dolor sit</b></p>
                                                            <p class="card-text text-justify">Lorem ipsum dolor sit amet,
                                                                consectetur adipiscing elit, sed do eiusmod tempor
                                                                incididunt ut labore et </p>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>


                                    </div>
                                </div>
                            </div>

                        </aside>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <!--************************************
                        Main End
                      *************************************-->
@endsection
